CONTAINER Toolcaweight
{
	NAME Toolcaweight;

	INCLUDE ToolBase;

	HIDE MDATA_COMMANDGROUP;

	GROUP MDATA_MAINGROUP
	{
		COLUMNS 1;
						
		GROUP ID_CA_WEIGHT_TOOL_PAINT_GROUP
		{
			COLUMNS 2;
			
			BOOL ID_CA_WEIGHT_TOOL_PROJECTION { SCALE_H; }
			BOOL ID_CA_WEIGHT_TOOL_VISIBLE_ONLY { SCALE_H; }
			
			BOOL ID_CA_WEIGHT_TOOL_SELECTED { SCALE_H; }
			BOOL ID_CA_WEIGHT_TOOL_NORMALIZE { SCALE_H; }				
		}
				
		GROUP
		{
			COLUMNS 2;

			REAL ID_CA_WEIGHT_TOOL_STRENGTH { UNIT PERCENT; MIN -100.0; MINSLIDER 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			LONG ID_CA_WEIGHT_TOOL_MODE
			{
				FIT_H; SCALE_H;

				CYCLE
				{
					ID_CA_WEIGHT_TOOL_MODE_ADD;
					ID_CA_WEIGHT_TOOL_MODE_SPRAY;
					ID_CA_WEIGHT_TOOL_MODE_ERASE;
					ID_CA_WEIGHT_TOOL_MODE_ABS;
					ID_CA_WEIGHT_TOOL_MODE_SMOOTH;
					ID_CA_WEIGHT_TOOL_MODE_BLEED;
					ID_CA_WEIGHT_TOOL_MODE_INTENSITY;
					ID_CA_WEIGHT_TOOL_MODE_REMAP;
					ID_CA_WEIGHT_TOOL_MODE_PRUNE;
					ID_CA_WEIGHT_TOOL_MODE_DROPPER;
				}
			}
			
			SPLINE ID_CA_WEIGHT_TOOL_SPLINE	{  }
			STATICTEXT { JOINENDSCALE; }	
		}
		
		GROUP ID_CA_WEIGHT_TOOL_PAINT_FN_GROUP
		{
			COLUMNS 2; HIDDEN;
			
			BUTTON ID_CA_WEIGHT_TOOL_APPLY_ALL { SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_APPLY_SELECTED { SCALE_H; }
			
			BUTTON ID_CA_WEIGHT_TOOL_REASSIGN { SCALE_H; HIDDEN; }
		}
							
		GROUP ID_CA_WEIGHT_TOOL_BRUSH_GROUP
		{
			COLUMNS 2; DEFAULT 1;
			
			LONG ID_CA_WEIGHT_TOOL_FALLOFF
			{
				FIT_H; SCALE_H;

				CYCLE
				{
					ID_CA_WEIGHT_TOOL_FALLOFF_NONE;
					ID_CA_WEIGHT_TOOL_FALLOFF_SIMPLE;
					ID_CA_WEIGHT_TOOL_FALLOFF_LINEAR;
					ID_CA_WEIGHT_TOOL_FALLOFF_DOME;
					ID_CA_WEIGHT_TOOL_FALLOFF_BELL;
					ID_CA_WEIGHT_TOOL_FALLOFF_CIRCLE;
					ID_CA_WEIGHT_TOOL_FALLOFF_NEEDLE;
					ID_CA_WEIGHT_TOOL_FALLOFF_SPLINE;
				}
			}
						
			LONG ID_CA_WEIGHT_TOOL_PEN
			{
				FIT_H; SCALE_H;

				CYCLE
				{
					ID_CA_WEIGHT_TOOL_PEN_NONE;
					ID_CA_WEIGHT_TOOL_PEN_RADIUS;
					ID_CA_WEIGHT_TOOL_PEN_STRENGTH;
					ID_CA_WEIGHT_TOOL_PEN_HARDNESS;
				}
			}
			
			REAL ID_CA_WEIGHT_TOOL_RADIUS { FIT_H; SCALE_H; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
			
			REAL ID_CA_WEIGHT_TOOL_WIDTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
			
			REAL ID_CA_WEIGHT_TOOL_HARDNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }

			SPLINE ID_CA_WEIGHT_TOOL_FALLOFF_CURVE {  }
			STATICTEXT { JOINENDSCALE; }
		}	
		
		GROUP ID_CA_WEIGHT_TOOL_CLAMP_GROUP
		{
			COLUMNS 2;

			BOOL ID_CA_WEIGHT_TOOL_CLAMP_LOWER_ENABLE { }
			REAL ID_CA_WEIGHT_TOOL_CLAMP_LOWER { FIT_H; SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

			BOOL ID_CA_WEIGHT_TOOL_CLAMP_UPPER_ENABLE { }
			REAL ID_CA_WEIGHT_TOOL_CLAMP_UPPER { FIT_H; SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		}				
	}
	
	GROUP ID_CA_WEIGHT_TOOL_SYMMETRY_GROUP
	{
		COLUMNS 2;
		
		BOOL ID_CA_WEIGHT_TOOL_SYMMETRY { }
		STATICTEXT { NEWLINE; }
				
		LONG ID_CA_WEIGHT_TOOL_SYMMETRY_MODE
		{
			SCALE_H;
		
			CYCLE
			{
				ID_CA_WEIGHT_TOOL_SYMMETRY_MODE_SINGLE;
				ID_CA_WEIGHT_TOOL_SYMMETRY_MODE_NAME;
				ID_CA_WEIGHT_TOOL_SYMMETRY_MODE_HIEARCHY;
			}
		}
		REAL ID_CA_WEIGHT_TOOL_SYMMETRY_RAD { SCALE_H; UNIT METER; MIN 0.0; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
		
		STRING ID_CA_WEIGHT_TOOL_SYMMETRY_MODE_NAME_LEFT { }
		STRING ID_CA_WEIGHT_TOOL_SYMMETRY_MODE_NAME_RIGHT { }
		
		LONG ID_CA_WEIGHT_TOOL_SYMMETRY_COORD
		{
			SCALE_H;
		
			CYCLE
			{
				ID_CA_WEIGHT_TOOL_SYMMETRY_COORD_LOCAL;
				ID_CA_WEIGHT_TOOL_SYMMETRY_COORD_WORLD;
				ID_CA_WEIGHT_TOOL_SYMMETRY_COORD_CUSTOM;
			}
		}
		
		LONG ID_CA_WEIGHT_TOOL_SYMMETRY_MIRROR
		{
			SCALE_H;
		
			CYCLE
			{
				ID_CA_WEIGHT_TOOL_SYMMETRY_MIRROR_XY;
				ID_CA_WEIGHT_TOOL_SYMMETRY_MIRROR_YZ;
				ID_CA_WEIGHT_TOOL_SYMMETRY_MIRROR_XZ;
			}
		}
		
		LINK ID_CA_WEIGHT_TOOL_SYMMETRY_COORD_CUSTOM_OBJECT { ACCEPT { Obase; } }
		STATICTEXT { JOINEND; }
	}
	
	GROUP ID_CA_WEIGHT_TOOL_JOINTS_GROUP
	{
		SCALE_V; DEFAULT 1;
						
		GROUP ID_CA_WEIGHT_TOOL_JOINT_FN_GROUP
		{
			COLUMNS 4; HIDDEN; DEFAULT 1;			

			BUTTON ID_CA_WEIGHT_TOOL_FN_CLEARWEIGHT { SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_COPY { SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_REPLACE { SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_MERGE { SCALE_H; }

			BUTTON ID_CA_WEIGHT_TOOL_NORMALIZE_ALL { SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_MIRROR { SCALE_H; }
				
			LONG ID_CA_WEIGHT_TOOL_FLIP_PLANE
			{
				CUSTOMGUI CYCLEBUTTON; SCALE_H;
				CYCLE
				{
					ID_CA_WEIGHT_TOOL_FLIP_PLANE_XY;
					ID_CA_WEIGHT_TOOL_FLIP_PLANE_YZ;
					ID_CA_WEIGHT_TOOL_FLIP_PLANE_XZ;
				}
			}
			
			BUTTON ID_CA_WEIGHT_TOOL_BAKE { SCALE_H; }
		}
			
		GROUP
		{
			COLUMNS 3;

			BOOL ID_CA_WEIGHT_TOOL_LOCK_LIST { }
			LONG ID_CA_WEIGHT_TOOL_SORT_LIST
			{
				CYCLE
				{
					ID_CA_WEIGHT_TOOL_SORT_LIST_FLAT;
					ID_CA_WEIGHT_TOOL_SORT_LIST_HIERARCHY;
					ID_CA_WEIGHT_TOOL_SORT_LIST_NAME;
				}
			}
			STRING ID_CA_WEIGHT_TOOL_FILTER_LIST { SCALE_H; }
		}

		GROUP
		{
			COLUMNS 3; HIDDEN;

			BUTTON ID_CA_WEIGHT_TOOL_JOINTS_LOCK { FIT_H; SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_JOINTS_UNLOCK { FIT_H; SCALE_H; }
			BUTTON ID_CA_WEIGHT_TOOL_JOINTS_UNLOCKALL { FIT_H; SCALE_H; }
		}		

		ITEMTREE ID_CA_WEIGHT_TOOL_JOINTS
		{
			COLUMNS 3;
			COLOR;
			MULTIPLE;
			ICON;
			SCALE_V;
			PADLOCK;
			DRAGDROP;
			ROWS 8;
			NORENAME;
			NOLAYOUTMODE;
		}

		LONG ID_CA_WEIGHT_TOOL_DIRTY { HIDDEN; }
	}
	
	GROUP ID_CA_WEIGHT_TOOL_SHEET_GROUP
	{
		SCALE_V; HIDDEN;
		
		GROUP ID_CA_WEIGHT_TOOL_SHEET_OPTIONS_GROUP
		{
			COLUMNS 2; HIDDEN;

			BOOL ID_CA_WEIGHT_TOOL_FOCUS { }
			BOOL ID_CA_WEIGHT_TOOL_LINK_SELECTION { }
			
			BOOL ID_CA_WEIGHT_TOOL_SHOWALL_JOINTS { HIDDEN; }
			
			BOOL ID_CA_WEIGHT_TOOL_TOTAL { }
			BOOL ID_CA_WEIGHT_TOOL_FULLWEIGHTED { }
		}
		
		GROUP ID_CA_WEIGHT_TOOL_SHEET_FILTER_GROUP
		{
			COLUMNS 1;
			
			GROUP
			{
				COLUMNS 3;
			
				LONG ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER
				{
					SCALE_H;
					
					CYCLE
					{
						ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_NONE;
						ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_LESS;
						ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_MORE;
						ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_RANGE;
						ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_FOCUS;
					}
				}
				BOOL ID_CA_WEIGHT_TOOL_WEIGHTS_SELECTION { }
				BOOL ID_CA_WEIGHT_TOOL_WEIGHTS_HIDE_ZERO { }
			}
			
			GROUP
			{
				COLUMNS 2;
				
				REAL ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_MIN { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
				REAL ID_CA_WEIGHT_TOOL_WEIGHTS_FILTER_MAX { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			}
		}
				
		GROUP ID_CA_WEIGHT_TOOL_SHEET_EDIT_GROUP
		{
			DEFAULT 1;
						
			GROUP
			{
				COLUMNS 5;
				
				LONG ID_CA_WEIGHT_TOOL_WEIGHTS_SLIDER_MODE
				{
					CYCLE
					{
						ID_CA_WEIGHT_TOOL_MODE_ADD;
						ID_CA_WEIGHT_TOOL_MODE_ERASE;
						ID_CA_WEIGHT_TOOL_MODE_ABS;
						ID_CA_WEIGHT_TOOL_MODE_SMOOTH;
						ID_CA_WEIGHT_TOOL_MODE_BLEED;
						ID_CA_WEIGHT_TOOL_MODE_INTENSITY;
						ID_CA_WEIGHT_TOOL_MODE_REMAP;
						ID_CA_WEIGHT_TOOL_MODE_PRUNE;
						ID_CA_WEIGHT_TOOL_MODE_ROUND;
					}
				}
					
				LONG ID_CA_WEIGHT_TOOL_EDITOR_ROUND_TO
				{
					CYCLE
					{
						ID_CA_WEIGHT_TOOL_EDITOR_ROUND_TO_1;
						ID_CA_WEIGHT_TOOL_EDITOR_ROUND_TO_5;
						ID_CA_WEIGHT_TOOL_EDITOR_ROUND_TO_10;
					}
				}
				
				REAL ID_CA_WEIGHT_TOOL_EDITOR_SLIDER { SCALE_H; UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				BUTTON ID_CA_WEIGHT_TOOL_EDITOR_SLIDER_SET { }
				BUTTON ID_CA_WEIGHT_TOOL_EDITOR_SLIDER_ZERO { }
				BOOL ID_CA_WEIGHT_TOOL_SLIDER_NORMALIZE { }	
			}
		}
		
		GROUP
		{
			SCALE_V;		
		
			SPREADSHEET ID_CA_WEIGHT_TOOL_EDITOR_WEIGHTS { SCALE_V; }
		}
	}
	
	GROUP ID_CA_WEIGHT_TOOL_AUTOWEIGHT_GROUP
	{
		COLUMNS 1; HIDDEN;

		GROUP
		{
			COLUMNS 3;
			
			LONG ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_MODE
			{
				FIT_H; SCALE_H;

				CYCLE
				{
					ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_MODE_DISTANCE;
					ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_MODE_VISIBLE;
				}
			}
			LONG ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_JOINTS { MIN 1; FIT_H; SCALE_H; }
			BOOL ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_SMOOTH { HIDDEN; }
			BOOL ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_SELECTED_VERTICES { }
		}

		GROUP
		{
			REAL ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_FALLOFF { UNIT PERCENT; MIN 0.0; MAX 100.0; FIT_H; SCALE_H; CUSTOMGUI REALSLIDER; }
			REAL ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT_VIS { UNIT PERCENT; MIN 0.0; MAX 100.0; FIT_H; SCALE_H; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP
		{
			REAL ID_CA_WEIGHT_TOOL_AUTOWEIGHT_DISTANCE { UNIT PERCENT; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
		}
			
		BUTTON ID_CA_WEIGHT_TOOL_FN_AUTOWEIGHT { FIT_H; SCALE_H; }
	}
	
	GROUP ID_CA_WEIGHT_TOOL_SMOOTH_GROUP
	{
		HIDDEN;
		
		GROUP
		{
			COLUMNS 2;
					
			REAL ID_CA_WEIGHT_TOOL_SMOOTH_STRENGTH { UNIT PERCENT; MIN -100.0; MINSLIDER 0.0; MAX 100; CUSTOMGUI REALSLIDER; SCALE_H; }		
			REAL ID_CA_WEIGHT_TOOL_SMOOTH_DISTANCE { UNIT METER; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
		}
		
		SPLINE ID_CA_WEIGHT_TOOL_SMOOTH_CURVE {  }
		
		GROUP
		{
			COLUMNS 2;
			
			BUTTON ID_CA_WEIGHT_TOOL_SMOOTH { SCALE_H; }	
			BOOL ID_CA_WEIGHT_TOOL_SMOOTH_INTERACTIVE { }
		}
	}
		
	GROUP ID_CA_WEIGHT_TOOL_DISPLAY_GROUP
	{		
		GROUP
		{
			COLUMNS 3;
	
			BOOL ID_CA_WEIGHT_TOOL_DISPLAY { HIDDEN; }
		
			BOOL ID_CA_WEIGHT_TOOL_PREVIEW { }
			BOOL ID_CA_WEIGHT_TOOL_DISPLAY_FALLOFF { }
			BOOL ID_CA_WEIGHT_TOOL_SHOWALL { }
			
			BOOL ID_CA_WEIGHT_TOOL_DISPLAY_EFFECTORS { }
			BOOL ID_CA_WEIGHT_TOOL_DISPLAY_MOUSEIN { }
			BOOL ID_CA_WEIGHT_TOOL_DISPLAY_POINTS { }

			BOOL ID_CA_WEIGHT_TOOL_DISPLAY_CURSOR { }
		}

		SEPARATOR { }
		
		GROUP
		{
			COLUMNS 2;
			
			LONG ID_CA_WEIGHT_TOOL_DISPLAY_MOUSEOVER
			{
				SCALE_H;
			
				CYCLE
				{
					ID_CA_WEIGHT_TOOL_DISPLAY_MOUSEOVER_NONE;
					ID_CA_WEIGHT_TOOL_DISPLAY_MOUSEOVER_SELECTED;
					ID_CA_WEIGHT_TOOL_DISPLAY_MOUSEOVER_ALL;
				}
			}
			STATICTEXT { NEWLINE; }

			LONG ID_CA_WEIGHT_TOOL_DISPLAY_COLOR_MODE
			{
				SCALE_H;

				CYCLE
				{
					ID_CA_WEIGHT_TOOL_DISPLAY_COLOR_MODE_OBJECT;
					ID_CA_WEIGHT_TOOL_DISPLAY_COLOR_MODE_SINGLE;
					ID_CA_WEIGHT_TOOL_DISPLAY_COLOR_MODE_RAINBOW;
				}
			}
			
			LONG ID_CA_WEIGHT_TOOL_SELECTED_COLOR_MODE
			{
				SCALE_H;

				CYCLE
				{
					ID_CA_WEIGHT_TOOL_SELECTED_COLOR_MODE_OBJECT;
					ID_CA_WEIGHT_TOOL_SELECTED_COLOR_MODE_WEIGHT;
					ID_CA_WEIGHT_TOOL_SELECTED_COLOR_MODE_CUSTOM;
				}
			}			
		}
		
		SEPARATOR { }
		
		GROUP
		{
			COLUMNS 2;
			
			REAL ID_CA_WEIGHT_TOOL_DISPLAY_LOWER { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			REAL ID_CA_WEIGHT_TOOL_DISPLAY_UPPER { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		}
		
		REAL ID_CA_WEIGHT_TOOL_DISPLAY_FADE { FIT_H; SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_WEIGHT_TOOL_DISPLAY_HSIZE { SCALE_H; MIN 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; HIDDEN; }

		SEPARATOR { LINE; }

		GRADIENT  ID_CA_WEIGHT_TOOL_DISPLAY_COLOR { COLOR;	}

		COLOR ID_CA_WEIGHT_TOOL_DISPLAY_CURSOR_COLOR { }
		SEPARATOR { }
		COLOR ID_CA_WEIGHT_TOOL_DISPLAY_ZERO_COLOR { }
		SEPARATOR { }
		COLOR ID_CA_WEIGHT_TOOL_DISPLAY_FALLOFF_COLOR { }
		SEPARATOR { }
		COLOR ID_CA_WEIGHT_TOOL_DISPLAY_ERASE_COLOR { }
		SEPARATOR { }
		COLOR ID_CA_WEIGHT_TOOL_DISPLAY_SELECTED_COLOR { }
	}
}
